/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.pe.peorb.registry.IPEORBInfo;
import filenet.pe.peorb.registry.ORBRouterInfo;
import filenet.vw.api.VWException;
import filenet.vw.base.IVWMemory;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.rmi.VWUnicastRemoteObject;
import filenet.vw.sysutils.GetEnvHelper;
import filenet.vw.sysutils.IVWRegistryTool;
import filenet.vw.sysutils.VWJavaLauncher;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class VWRegistryTool
extends VWUnicastRemoteObject
implements IVWRegistryTool,
IPEORBInfo,
IVWMemory {
    private static Logger logger = Logger.getLogger("filenet.vw.sysutils");
    private static String m_className = VWRegistryTool.class.getName();
    private int m_port = 32771;
    private String m_name = null;
    private HashMap m_references = new HashMap();
    private static VWRegistryTool m_regTool = null;
    public static final int REGISTRY_PORT = 32771;
    private static final String SERVICE_NAME = "FileNET.VW.VWRegistry";
    Hashtable orbRouters = new Hashtable(2);
    private static final String ROUTER_PREFIX = "FileNET.VW.VWRouter.";

    public static String _get_FILE_DATE() {
        return "$Date:   14 Oct 2008 10:13:52  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.26  $";
    }

    public static synchronized void bind(String name, Remote obj, int port) throws RemoteException, AlreadyBoundException, IOException, VWException {
        String method = "bind:" + port;
        logger.entering(m_className, method);
        int retryCount = 0;
        boolean done = false;
        while (!done) {
            try {
                VWRegistryTool.createRegistry(port).addRef(name);
                LocateRegistry.getRegistry(port).bind(name, obj);
                logger.fine(m_className, method, "Object " + name + " bound.");
                done = true;
            }
            catch (RemoteException ex) {
                logger.log(Level.FINE, m_className, method, "Exception while binding object " + name + " on port " + port, ex);
                if (retryCount < 100) {
                    logger.fine(m_className, method, "Number of retries: " + retryCount);
                    ++retryCount;
                    continue;
                }
                throw ex;
            }
        }
        logger.exiting(m_className, method);
    }

    public static synchronized void rebind(String name, Remote obj, int port) throws RemoteException, IOException, VWException {
        String method = "rebind:" + port;
        logger.entering(m_className, method);
        int retryCount = 0;
        boolean done = false;
        while (!done) {
            try {
                VWRegistryTool.createRegistry(port).addRef(name);
                LocateRegistry.getRegistry(port).rebind(name, obj);
                done = true;
            }
            catch (RemoteException ex) {
                logger.log(Level.FINE, m_className, method, "Exception while binding object " + name + " on port " + port, ex);
                if (retryCount < 100) {
                    logger.fine(m_className, method, "Number of retries: " + retryCount);
                    ++retryCount;
                    continue;
                }
                throw ex;
            }
        }
        logger.exiting(m_className, method);
    }

    public static synchronized void unbind(String name, int port) throws Exception {
        IVWRegistryTool regTool = VWRegistryTool.getRegistry(port);
        try {
            regTool.unbind(name);
        }
        catch (UnmarshalException unmarshalException) {
            // empty catch block
        }
    }

    public void ping() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRef(String name) throws RemoteException {
        HashMap hashMap = this.m_references;
        synchronized (hashMap) {
            this.m_references.put(name, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) throws RemoteException, NotBoundException {
        String method = "unbind:" + this.m_port;
        logger.entering(m_className, method);
        HashMap hashMap = this.m_references;
        synchronized (hashMap) {
            this.m_references.remove(name);
        }
        Registry reg = LocateRegistry.getRegistry(this.m_port);
        reg.unbind(name);
        logger.fine(m_className, method, "Object " + name + " unbound.");
        String[] names = reg.list();
        if (names == null || names.length == 0 || names.length == 1 && names[0].equals(this.m_name)) {
            if (this.m_references.size() == 0) {
                logger.fine(m_className, method, "Registry empty, unbinding VWRegistryTool.");
                this.unbind();
            } else {
                logger.fine("Unable to unbind VWRegistry tool because of the following references:");
                Iterator i = this.m_references.keySet().iterator();
                while (i.hasNext()) {
                    logger.fine(m_className, method, i.next().toString());
                }
            }
        }
        logger.exiting(m_className, method);
    }

    public void unbind() throws RemoteException {
        String method = "unbind";
        try {
            LocateRegistry.getRegistry(this.m_port).unbind(this.m_name);
            logger.fine(m_className, "unbind", this.m_name + " unbound.");
        }
        catch (Exception e) {
            logger.log(Level.FINE, m_className, method, "", e);
        }
        if (!Boolean.getBoolean("filenet.rmi.registry.inprocess")) {
            System.exit(0);
        }
    }

    private VWRegistryTool(int port) throws RemoteException, AlreadyBoundException {
        this.m_port = port;
        this.m_name = "FileNET.VW.VWRegistry." + Integer.toString(this.m_port);
        this.bindService();
    }

    private void bindService() throws RemoteException, AlreadyBoundException {
        String method = "bindService:" + this.m_port;
        logger.entering(m_className, method);
        Registry reg = null;
        try {
            reg = LocateRegistry.getRegistry(this.m_port);
            reg.list();
        }
        catch (RemoteException e) {
            reg = LocateRegistry.createRegistry(this.m_port);
            reg.list();
            reg.bind(this.m_name, this);
            logger.fine(m_className, method, this.m_name + " is bound to port " + this.m_port + ", with a newly created registry..");
            return;
        }
        try {
            IVWRegistryTool tmp = (IVWRegistryTool)reg.lookup(this.m_name);
            tmp.ping();
            logger.fine(m_className, method, this.m_name + " is already bound to port " + this.m_port + ", with an existing registry..");
            throw new AlreadyBoundException();
        }
        catch (Exception e) {
            if (e instanceof AlreadyBoundException) {
                throw (AlreadyBoundException)e;
            }
            reg.rebind(this.m_name, this);
            logger.fine(m_className, method, this.m_name + " is bound to port " + this.m_port + ", with an existing registry..");
            logger.exiting(m_className, method);
            return;
        }
    }

    private static IVWRegistryTool getRegistry(String host, int port) throws RemoteException, NotBoundException {
        String m_method = "getRegistry(" + host + ":" + port + ")";
        String s = "FileNET.VW.VWRegistry." + port;
        logger.finest(m_className, m_method, s);
        return (IVWRegistryTool)LocateRegistry.getRegistry(host, port).lookup(s);
    }

    private static IVWRegistryTool getRegistry(int port) throws RemoteException, NotBoundException {
        return (IVWRegistryTool)LocateRegistry.getRegistry(port).lookup("FileNET.VW.VWRegistry." + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IVWRegistryTool createRegistry(int port) throws RemoteException, AccessException, IOException, VWException {
        Throwable throwable3;
        IVWRegistryTool iVWRegistryTool;
        String method = "createRegistry:" + port;
        logger.entering(m_className, method);
        String errorMsg = "";
        try {
            IVWRegistryTool regtool = VWRegistryTool.getRegistry(port);
            regtool.ping();
            iVWRegistryTool = regtool;
        }
        catch (Exception e) {
            ArrayList<String> javaArgs;
            block24: {
                BufferedInputStream errorStream;
                if (Boolean.getBoolean("filenet.rmi.registry.inprocess")) {
                    logger.fine(m_className, method, "Creating new VWRegistryTool in-process.");
                    try {
                        VWRegistryTool tmp = new VWRegistryTool(port);
                    }
                    catch (AlreadyBoundException ex) {}
                } else {
                    String envValue;
                    javaArgs = null;
                    GetEnvHelper env = null;
                    try {
                        env = new GetEnvHelper();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, m_className, method, "Error while trying to lookup VWREGISTRYTOOL_JAVAFLAGS environment variable.", ex);
                    }
                    if (env != null && (envValue = env.getEnv("VWREGISTRYTOOL_JAVAFLAGS")) != null) {
                        javaArgs = new ArrayList<String>();
                        StringTokenizer tokens = new StringTokenizer(envValue);
                        while (tokens.hasMoreTokens()) {
                            javaArgs.add(tokens.nextToken());
                        }
                    }
                    if (javaArgs == null) {
                        javaArgs = new ArrayList();
                        javaArgs.add("-Xmx128M");
                    }
                    logger.fine(m_className, method, "Launching new VWRegistryTool process.");
                    Process regProcess = VWJavaLauncher.exec(javaArgs.toArray(new String[0]), "filenet.vw.sysutils.VWRegistryTool /p " + Integer.toString(port), true, null);
                    try {
                        regProcess.getInputStream().close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    errorStream = new BufferedInputStream(regProcess.getErrorStream());
                    byte[] buffer = new byte[4096];
                    logger.fine(m_className, method, "Checking status of launched VWRegistryTool.");
                    int size = errorStream.read(buffer);
                    errorMsg = new String(buffer).trim();
                    logger.fine(m_className, method, "VWRegistryTool status: " + errorMsg);
                    Object var10_19 = null;
                    try {
                        errorStream.close();
                    }
                    catch (Exception e3) {}
                }
                break block24;
                catch (Throwable throwable2) {
                    Object var10_20 = null;
                    try {
                        errorStream.close();
                        throw throwable2;
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    throw throwable2;
                }
            }
            try {
                logger.fine(m_className, method, "getRegistry again!");
                javaArgs = VWRegistryTool.getRegistry(port);
            }
            catch (NotBoundException ex) {
                try {
                    System.out.println("Still not working?");
                    if (errorMsg.length() <= 0) throw new VWException("vw.sysutils.VWRegistryTool.UnableToLookupRegistry", "Unexpected error, unable to lookup registry.");
                    throw new VWException("vw.sysutils.VWRegistryTool.CreateRegistryError", "Error starting registry on port {0}: {1}", new Integer(port), errorMsg);
                }
                catch (Throwable throwable3) {
                    Object var13_12 = null;
                    logger.exiting(m_className, method);
                }
            }
            Object var13_11 = null;
            logger.exiting(m_className, method);
            return javaArgs;
        }
        Object var13_10 = null;
        logger.exiting(m_className, method);
        return iVWRegistryTool;
        throw throwable3;
    }

    private static void usage() {
        System.out.println("\n\n1.  Start the RMI Registry at specified port or 32771 by default.");
        System.out.println("Usage:  VWRegistryTool [/p port]");
        System.out.println("\n2.  Stop the RMI Registry started by the previous command \nat specified port or 32771 by default.");
        System.out.println("Usage:  VWRegistryTool [/u /p port]");
        System.out.println("\n3.  Bind an ORB RMI router.");
        System.out.println("Usage:  VWRegistryTool /orbCreate \n\t/orb.router.name={routername, e.g. vwrouter.ORB}\n\t/orb.region=region#\n\t   [/orb.router.port=32771 ]\n\t   [/orb.router.host=localhost]\n\t   [/orb.server.name=localhost]\n\t   [/orb.server.port=1055]");
        System.out.println("\n4.  List  ORB RMI routers.");
        System.out.println("Usage:  VWRegistryTool /orbList \n\t   [/orb.router.port=32771 ]\n\t   [/orb.router.host=localhost]");
        System.out.println("\n5.  Unbind an ORB RMI router.");
        System.out.println("Usage:  VWRegistryTool /orbUnbind \n\t/orb.router.name={routername, e.g. vwrouter.ORB}\n\t   [/orb.router.port=32771 ]\n\t   [/orb.router.host=localhost]\n\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        String method = "main";
        try {
            String PORT = "p";
            String UNBIND = "u";
            String ORB_CREATE = "orbCreate";
            String ORB_LIST = "orbList";
            String ORB_UNBIND = "orbUnbind";
            String HELP = "?";
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            int port = c.getIntParameter("p", 32771);
            if (c.isPresent("?")) {
                VWRegistryTool.usage();
            }
            if (c.isPresent("u")) {
                try {
                    IVWRegistryTool gVWRegistry = null;
                    String s = "FileNET.VW.VWRegistry." + port;
                    String lookupHost = "rmi://localhost:" + port + "/" + s;
                    System.out.println("Unbinding " + lookupHost + "...");
                    gVWRegistry = (IVWRegistryTool)Naming.lookup(lookupHost);
                    gVWRegistry.unbind();
                }
                catch (Exception e) {
                    logger.log(Level.FINE, m_className, method, "", e);
                }
                System.exit(0);
            }
            if (c.isPresent("orbCreate")) {
                VWRegistryTool.testORBCreate(c);
            } else if (c.isPresent("orbList")) {
                VWRegistryTool.testORBList(c);
            } else if (c.isPresent("orbUnbind")) {
                VWRegistryTool.testUnbindORBRouter(c);
            } else {
                try {
                    m_regTool = new VWRegistryTool(port);
                }
                catch (AlreadyBoundException e) {
                    System.exit(0);
                }
            }
            System.err.println("");
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(100);
        }
    }

    private static boolean isLocalHost(String host) {
        return host == null || host.equals("localhost") || host.equals("127.0.0.1");
    }

    public static void ORB_bind_router(String host, int port, String name, ORBRouterInfo routerInfo) throws Exception {
        IVWRegistryTool regTool;
        String m_method;
        block4: {
            m_method = "ORB_bind_router:" + host + ":" + port + "/" + name;
            logger.entering(m_className, m_method);
            regTool = null;
            try {
                regTool = VWRegistryTool.getRegistry(host, port);
                regTool.ping();
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                if (!VWRegistryTool.isLocalHost(host)) break block4;
                try {
                    regTool = VWRegistryTool.createRegistry(port);
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                    Thread.sleep(10000L);
                    regTool = VWRegistryTool.getRegistry(host, port);
                }
            }
        }
        IPEORBInfo orbTool = (IPEORBInfo)((Object)regTool);
        orbTool.orb_bind(name, routerInfo);
        logger.exiting(m_className, m_method);
    }

    public static ORBRouterInfo ORB_unbind_router(String host, int port, String name) throws Exception {
        String m_method;
        block3: {
            m_method = "ORB_unbind_router:" + host + ":" + port + "/" + name;
            logger.entering(m_className, m_method);
            try {
                IVWRegistryTool regTool = VWRegistryTool.getRegistry(host, port);
                if (regTool == null) break block3;
                IPEORBInfo orbTool = (IPEORBInfo)((Object)regTool);
                ORBRouterInfo o = orbTool.orb_unbind(name);
                logger.finest(m_className, m_method, "orb_unbind " + name + " returns " + (o == null ? "NULL??" : o.toString()));
                ORBRouterInfo oRBRouterInfo = o;
                Object var9_8 = null;
                logger.exiting(m_className, m_method);
                return oRBRouterInfo;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
        logger.finest(m_className, m_method, "Cannot find VWRegistry?");
        throw new Exception("Unable to unbind " + name + " at " + host + ":" + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORBRouterInfo ORB_get_router(String host, int port, String name) throws Exception {
        String m_method = "ORB_get_router:" + host + ":" + port + "/" + name;
        logger.entering(m_className, m_method);
        try {
            IPEORBInfo o = (IPEORBInfo)LocateRegistry.getRegistry(host, port).lookup(name);
            ORBRouterInfo r = o.orb_get_router(name);
            if (r != null) {
                logger.finest(m_className, m_method, r.toString());
            }
            ORBRouterInfo oRBRouterInfo = r;
            Object var8_7 = null;
            logger.exiting(m_className, m_method);
            return oRBRouterInfo;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORBRouterInfo[] ORB_list(String host, int port) throws Exception {
        String m_method = "ORB_list:" + host + ":" + port;
        logger.entering(m_className, m_method);
        try {
            IPEORBInfo o = (IPEORBInfo)((Object)VWRegistryTool.getRegistry(host, port));
            ORBRouterInfo[] oRBRouterInfoArray = o.orb_list();
            Object var6_5 = null;
            logger.exiting(m_className, m_method);
            return oRBRouterInfoArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    public ORBRouterInfo orb_get_router(String name) throws Exception {
        return (ORBRouterInfo)this.orbRouters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orb_bind(String name, ORBRouterInfo info) throws Exception {
        String m_method = "orb_bind:" + name;
        logger.entering(m_className, m_method);
        try {
            Hashtable hashtable = this.orbRouters;
            synchronized (hashtable) {
                if (this.orbRouters.get(name) != null) {
                    throw new AlreadyBoundException(name);
                }
                VWRegistryTool.bind(name, this, this.m_port);
                this.orbRouters.put(name, info);
            }
            Object var7_6 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORBRouterInfo orb_unbind(String name) throws Exception {
        ORBRouterInfo o = null;
        Hashtable hashtable = this.orbRouters;
        synchronized (hashtable) {
            this.unbind(name);
            o = (ORBRouterInfo)this.orbRouters.remove(name);
        }
        return o;
    }

    public ORBRouterInfo[] orb_list() throws Exception {
        ORBRouterInfo[] res = this.orbRouters.values().toArray(new ORBRouterInfo[0]);
        return res;
    }

    private static void testORBCreate(VWCommandLineArgs c) {
        try {
            String orbRouterName = c.getParameter("orb.router.name");
            String orbRouterHost = c.getParameter("orb.router.host", "localhost");
            if (orbRouterName == null) {
                return;
            }
            orbRouterName = VWRegistryTool.fixupORBRouterName(orbRouterName);
            int orbRouterPort = c.getIntParameter("orb.router.port", 32771);
            String orbServerName = c.getParameter("orb.server.name", "localhost");
            int orbServerPort = c.getIntParameter("orb.server.port", 1050);
            int region = c.getIntParameter("orb.region", 1);
            ORBRouterInfo o = new ORBRouterInfo(orbRouterHost + ":" + orbRouterPort + "/" + orbRouterName, orbServerName, orbServerPort, region);
            VWRegistryTool.ORB_bind_router(orbRouterHost, orbRouterPort, orbRouterName, o);
            System.out.println("Successfully bound " + orbRouterName + " to " + orbRouterHost + ":" + orbRouterPort + " with [" + o + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String fixupORBRouterName(String orbRouterName) {
        if (!orbRouterName.startsWith(ROUTER_PREFIX)) {
            orbRouterName = ROUTER_PREFIX + orbRouterName;
        }
        return orbRouterName;
    }

    private static void testORBList(VWCommandLineArgs c) {
        try {
            int orbRouterPort = c.getIntParameter("orb.router.port", 32771);
            String orbRouterHost = c.getParameter("orb.router.host", "localhost");
            if (orbRouterPort == -1) {
                return;
            }
            ORBRouterInfo[] allOrbs = VWRegistryTool.ORB_list(orbRouterHost, orbRouterPort);
            int nOrbs = allOrbs == null ? 0 : allOrbs.length;
            for (int i = 0; i < nOrbs; ++i) {
                System.out.println(i + ":" + allOrbs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testUnbindORBRouter(VWCommandLineArgs c) {
        try {
            String orbRouterName = c.getParameter("orb.router.name");
            String orbRouterHost = c.getParameter("orb.router.host", "localhost");
            if (orbRouterName == null) {
                return;
            }
            orbRouterName = VWRegistryTool.fixupORBRouterName(orbRouterName);
            int orbRouterPort = c.getIntParameter("orb.router.port", 32771);
            ORBRouterInfo o = VWRegistryTool.ORB_unbind_router(orbRouterHost, orbRouterPort, orbRouterName);
            System.out.println("Successfully unbound " + orbRouterName + " to " + orbRouterHost + ":" + orbRouterPort + " which had [" + o + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

